/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.config;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class Configuration {
    private final CommonConfiguration commonConfig = new CommonConfiguration();
    final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void load() {
        Path configPath = FabricLoader.getInstance().getConfigDir().normalize().resolve("connectivity.json");
        File config = configPath.toFile();
        if (!config.exists()) {
            Connectivity.LOGGER.warn("Config for connectivity not found, recreating default");
            this.save();
        } else {
            try {
                this.commonConfig.deserialize((JsonObject)this.gson.fromJson((Reader)Files.newBufferedReader(configPath), JsonObject.class));
            }
            catch (IOException e) {
                Connectivity.LOGGER.error("Could not read config from:" + configPath, (Throwable)e);
            }
        }
    }

    public void save() {
        Path configPath = FabricLoader.getInstance().getConfigDir().normalize().resolve("connectivity.json");
        try {
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            this.gson.toJson((Object)this.commonConfig.serialize(), JsonObject.class, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            Connectivity.LOGGER.error("Could not write config to:" + configPath, (Throwable)e);
        }
    }

    public CommonConfiguration getCommonConfig() {
        return this.commonConfig;
    }
}

